var raQuickTour = new function() {

	/*
	 * Sets OS version information for the unsupportedOS pages.
	 * @param (string) appVersion - the current application version.
	 * @param (string) minOS - the minimum supported OS version.
	 * @param (string) maxOS - the maximum supported OS version.
	 * @param (string) currentOS - the current OS version.
	 */
	this.setVersionInfo = function(appVersion, minOS, maxOS, currentOS) {
		document.querySelectorAll('.appVersion').forEach(function f(e){
			e.innerText = appVersion;
		});
		document.querySelectorAll('.minOSVersion').forEach(function f(e){
			e.innerText = minOS;
		});
		document.querySelectorAll('.maxOSVersion').forEach(function f(e){
			e.innerText = maxOS;
		});
		document.querySelectorAll('.currentOSVersion').forEach(function f(e){
			e.innerText = currentOS;
		});
	}

	/**
		* Sets the app name in templates.
		* @param (string) appName - the name of the app
	 	*/
	this.setAppName = function(appName) {
		var containers = document.querySelectorAll('.template-app-name');
		containers.forEach(function(c){
			c.innerText = appName;
		});
	}

	/**
		* Sets the app bundle id in templates.
		* @param (string) bundleId - the bundle id of the app
	 	*/
	this.setBundleId = function(bundleId) {
		var containers = document.querySelectorAll('.template-bundle-id');
		containers.forEach(function(c){
			c.innerText = appName;
		});
	}

	/**
		* Sets the app tagline in templates.
		* @param (string) tagline - the tagline of the app
	 	*/
	this.setAppTagline = function(tagline) {
		var containers = document.querySelectorAll('.template-app-tagline');
		containers.forEach(function(c){
			c.innerText = tagline;
		});
	}

	/**
		* Sets the app icon in templates.
		* @param (string) appIcon - base64 png representation of the application icon
		* @param (string) appRetinaIcon - base64 png representation of the retina version of the application icon
	 	*/
	this.setAppIcon = function(appIcon, appRetinaIcon) {
		var containers = document.querySelectorAll('.template-app-icon');
		containers.forEach(function(c){
			c.setAttribute('src', 'data:image/png;base64,' + appIcon);
			c.setAttribute('srcset', 'data:image/png;base64,' + appRetinaIcon + ' 2x');
		});
	}

	/**
	* Adds a class to the body tag.
	* @param (string) className - the class to add.
 	*/
	this.addBodyClass = function(className) {
		document.body.classList.add(className);
	}

	/**
	* Removes a class from the body tag.
	* @param (string) className - the class to remove.
 	*/
	this.removeBodyClass = function(className) {
		document.body.classList.remove(className);
	}

	/**
	* Removes all classes from the body tag
 	*/
	this.clearBodyClass = function() {
		document.body.className = "";
	}

	/**
	 * Disables the right-click menu.
	 */
	this.disableContextMenu = function() {
		document.querySelector('body').setAttribute('oncontextmenu', 'event.preventDefault();');
	}

}
